/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/

#include <errno.h>
#include "WLCompositor.hpp"
#include "WLSurfaceEvent.hpp"

using namespace WaylandBackend;

WLCompositor::WLCompositor(struct wl_event_queue *eventQ)
:_wlCompositor(NULL)
,_wlID(0)
,_wlInterfaceName()
{
}

int
WLCompositor::init(struct wl_registry* registry, uint32_t name,
                   const char* interface, uint32_t version)
{
    int ret = -EINVAL;
    std::string inputInterface(interface);
    std::string compositorInterface("wl_compositor");

    if (inputInterface == compositorInterface)
    {
        _wlInterfaceName.assign(interface);
        _wlID = name;

        ret = 0;

        _wlCompositor = (struct wl_compositor*)
                        wl_registry_bind(registry, name,
                                         &wl_compositor_interface, version);

        if (NULL == _wlCompositor)
            ret = -ENOMEM;
    }

    return ret;
}

uint32_t
WLCompositor::getWLID()
{
    return _wlID;
}

std::string&
WLCompositor::getWLName()
{
    return _wlInterfaceName;
}

struct wl_surface*
WLCompositor::createSurface(WLSurfaceEvent *wlInputHandler)
{
    struct wl_surface *wlSurface = NULL;
    if (NULL != _wlCompositor)
    {
        wlSurface = wl_compositor_create_surface(_wlCompositor);

        if (NULL != wlSurface)
            wl_surface_set_user_data(wlSurface, wlInputHandler);
    }
    return wlSurface;
}

void
WLCompositor::destroySurface(struct wl_surface* wlSurface)
{
    if (NULL != wlSurface)
        wl_surface_destroy(wlSurface);
}


WLCompositor::~WLCompositor()
{
    if (NULL != _wlCompositor)
        wl_compositor_destroy(_wlCompositor);
}
